/*------------------------------------------------------------------------------*
 * File Name: CellFormat.c	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 2/19/2007 INIT_DLG_SIZE_NEEDED											*
 *	Jasmine 02/26/07 UTILITY_FUNC_FOR_TEXT_FORMAT								*
 *	Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS							*
 *	Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 *	Folger 05/09/07 ADD_STYLE_CONTROL											*
 *	Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX										*
 *	Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT								*
 *	Jasmine 08/13/07 MAKE_APPLY_UNDOABLE										*
 *	Folger 09/05/07 SHOW_ERROR_STATUS_BAR										*
 *	Jasmine 09/06/07 SHOW_ERROR_MESSAGE											*
 *	Jasmine 09/21/07 QA70-10401 SELDOM_USE_SO_REMOVE_FLOOD						*
 *	Fisher 11/14/07 ADD_MAP_ID_TO_CHM											*
 *	RVD 1/8/2008 QA70-10692 v8.0781 MERGE_ENTIRE_COLUMN							*
 *	Jasmine 02/18/08 QA80-11113 NOT_APPLY_UNCHANGED_FORMAT						*
 *	Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED		*
 *	CPY 2/26/08 QA80-11159 ORIGIN_TEXT_IN_WKS_CELL_NOT_ALLOW_MULTILINE			*
 *	CPY 2/26/08 QA70-11111 IGNORE_BLANK_MISSING_RANGE_STYLE						*
 *	Jasmine 08/28/08 QA80-12112 UPDATE_CONTROL_EVEN_IF_RANGE_IS_INVALID			*
 *	Kyle 08/11/2009 QA80-12339 CELL_FORMAT_ADD_FONT_AND_COLOR_CONTROL			*
 *	Jasmine 11/11/09 QA80-14602 ADD_READONLY_CHECKBOX							*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#define BASE_WINDOW ResizeDialog
#include "DynaDlg.h"
#include "okThemeID.h"
#include "TextFormat.h"	///Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS
#include "wks_utils.h"	// CPY 7/31/09 added this after compile error due to Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#include <o8dlg.h>

///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
#define BEFORE_UNDO_BLOCK				int idBefore = Project.UndoBlockId(); { UndoBlock block;
#define AFTER_UNDO_BLOCK				} int idAfter = Project.UndoBlockId(); 
///End MAKE_APPLY_UNDOABLE

enum{
	//CELL_FMT_NUMBER, 
	CELL_FMT_ALIGNMENT
};

static void _enable_tree(TreeNode& trNode, int nEnable = ENABLE)
{
	foreach(TreeNode trn in trNode.Children)
	{
		if(trn.GetNodeCount() > 0)
			_enable_tree(trn);
		else
		{
			trn.Enable = nEnable;
		}
	}
}

///Kyle 08/11/2009 QA80-12339 CELL_FORMAT_ADD_FONT_AND_COLOR_CONTROL
static int _gui_to_format_tree(DataRange& dr, TreeNode& trFmt, const TreeNode& trChanged, const TreeNode& trGUI)
{
	if(!dr || !trFmt || !trChanged || !trGUI)
		return FALSE;

	TreeNode trProp = trFmt.Root.CommonStyle;
	if(!trProp.IsValid())
		return FALSE;
	// change between undefined and defined
	int nUndefined;
	if(	trGUI.Color.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined) && nUndefined )
	{
		if(trChanged.Color)
			trChanged.Color.Remove();
	}
	else
	{
		if(!trProp.Color)			// undefined
			trChanged.Color.Replace(trGUI.Color);
	}
	if(	trGUI.FillColor.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined) && nUndefined )
	{
		if(trChanged.FillColor)
			trChanged.FillColor.Remove();
	}
	else
	{
		if(!trProp.Fill || !trProp.Fill.FillColor)			// undefined
			trChanged.FillColor.Replace(trGUI.FillColor);
	}
	if(	trGUI.Face.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined) && nUndefined )
	{
		if(trChanged.Face)
			trChanged.Face.Remove();
	}
	else
	{
		if(!trProp.Font || !trProp.Font.Face)			// undefined
			trChanged.Face.Replace(trGUI.Face);
	}
	if(	trGUI.Size.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined) && nUndefined )
	{
		if(trChanged.Size)
			trChanged.Size.Remove();
	}
	else
	{
		if(!trProp.Font || !trProp.Font.Size)			// undefined
			trChanged.Size.Replace(trGUI.Size);
	}

	//make sure trFmt has these nodes
	trProp.WrapText.nVal = FALSE;
	trProp.AllowEnter.nVal = TRUE;
	trProp.Float.nVal = FALSE;
	trProp.ReadOnly.nVal = FALSE;		///Jasmine 11/11/09 QA80-14602 ADD_READONLY_CHECKBOX
	trProp.Merge.nVal = GMC_NONE;
	trProp.Format.strVal = "";
	trProp.Control.strVal = "Origin Text Edit";
	trProp.Ellipsis.nVal = 0;
	trProp.Fill.FillColor.nVal = -1;
	trProp.Color.nVal = 0;
	trProp.Font.Face.nVal = 0;	// auto
	trProp.Font.Size.nVal = 12;	//

	int iRet = dr.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag");
	bool bRet = octree_copy_values_by_id(&trChanged, &trProp, true, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
	foreach(TreeNode cNode in trProp.Children)
    {
    	if(cNode.GetNodeCount())			// branch
    	{
    		foreach(TreeNode cSubNode in cNode.Children)
    		{
	    		TreeNode trNode = tree_get_node_by_tagname(trChanged, cSubNode.tagName, true);
				if(!trNode)
					cSubNode.Remove();
    		}
			if(cNode.GetNodeCount() == 0)
				cNode.Remove();
    	}
    	else
    	{
    		TreeNode trNode = tree_get_node_by_tagname(trChanged, cNode.tagName, true);
			if(!trNode)
				cNode.Remove();
    	}
    }
	return iRet;
}
///End CELL_FORMAT_ADD_FONT_AND_COLOR_CONTROL

class CellFormatDlg;
static CellFormatDlg* s_pCellFormatDlg = NULL;
#define STR_DLG_NAME "Format Cells"
class CellFormatDlg : public DynaDlg
{
public:
	
	CellFormatDlg() : DynaDlg(IDD_CELL_FORMAT_DLG, NULL, "ODlg8")
	{
		m_bDeleteOnDestroy = true;
	}
	DWORD DoModalEx(HWND hParent)
	{
		InitMsgMap();
		int nRet = DoModal(hParent);
		return nRet;
	}
	int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = Create(hParent, 0);
		Visible = true;
		return nRet;
	}
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_SIZE(OnDlgResize)
	ON_DESTROY(OnDestroy)
	ON_CHANGE_SELECTION(OnSelectionChange)
	ON_OK(OnClickOK)
	ON_BN_CLICKED(IDC_APPLY_FORMAT_BTN, OnApply)
	//ON_TAB_SEL_CHANGE(IDC_CELL_FORMAT_TAB, OnTabChange)
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	ON_RESTORESIZE(OnRestoreSize) //CPY 2/19/2007 INIT_DLG_SIZE_NEEDED
	ON_HELPINFO(OnHelp)

EVENTS_END
	
	//------ fisher 11/14/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_XF_CELLFORMAT;
		return true;
	}

	BOOL OnInitDialog()
	{
		ResizeDialog::OnInitDialog(IDC_CELL_FORMAT_TAB, STR_DLG_NAME);	
		m_tab = GetItem(IDC_CELL_FORMAT_TAB);
		//m_tab.InsertItem(CELL_FMT_NUMBER, "Number");
		m_tab.InsertItem(CELL_FMT_ALIGNMENT, "Text");
		//m_btnErrMessage = GetItem(IDC_ERR_MESSAGE_BOX);		//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR		///Jasmine 05/22/08 m_btnErrMessage_IS_IN_BASIC_CLASS_DYNA_DLG
		
		InitDynaControl(IDC_CELL_FORMAT_GRID);
		ConstructTree();
		update();
		GetItem(IDC_APPLY_FORMAT_BTN).Enable = false;		
		return TRUE;
	}	
	//------ CPY 2/19/2007 INIT_DLG_SIZE_NEEDED
	BOOL OnRestoreSize(DWORD dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
		pSz->top = -1;
		pSz->left = -1;
		pSz->width = 380;
		pSz->height = 470;
		return TRUE;
	}	
	//------
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
		//uint nButtonIDs[] = {IDCANCEL, IDOK, IDC_APPLY_FORMAT_BTN, 0};
		//RECT rr;
		//GetClientRect(GetItem(IDOK), rr);
		//int nEdge = GetControlGap(), ny=cy-RECT_HEIGHT(rr);
		////ArrangeControlsRightLeft(nButtonIDs, cx, ny);///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
		//
		//GetClientRect(GetItem(IDC_CELL_RANGE), rr);
		//rr.right = cx - nEdge;
		//MoveControl(GetItem(IDC_CELL_RANGE), rr); 
		//
		//GetClientRect(m_tab, rr);
		//rr.right = cx-nEdge;
		//rr.bottom = ny-nEdge;
		//MoveControl(m_tab, rr);
		//m_tab.GetWindowRect(&rr);
		//ScreenToClient(&rr);
		//m_tab.AdjustRect(FALSE, &rr);
		//Control ccGrid = GetItem(IDC_CELL_FORMAT_GRID);
		//ccGrid.MoveWindow(&rr);
		//
		//MoveControlsHelper	_temp(this);		///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
		//ArrangeControlsRightLeft(nButtonIDs, cx, ny);//only affect buttons
		resizeDialog(cx, cy);
		//------ End SHOW_ERROR_STATUS_BAR
		
		return TRUE;
	}
	BOOL OnDestroy(void)
	{
		DynaDlg::OnDestroy();
		if(m_bDeleteOnDestroy)
		{
			delete this;
			s_pCellFormatDlg = NULL;
		}		
		return true;
	}	
	BOOL OnSelectionChange( void )
	{
		//OnClickOK();//apply change	///Jasmine 02/15/07 should not call OnClickOK if not ON_OK
		Control ctrl;
		OnApply(ctrl);
		update();
		return TRUE;
	}
	/*
	BOOL OnTabChange(Control ctrl)
	{
		int nSelTab=m_tab.GetCurSel();
		GetItem(IDC_CELL_FORMAT_GRID).Visible = nSelTab==CELL_FMT_ALIGNMENT;
		return TRUE;
	}
	*/
	BOOL OnClickOK()
	{
		SetFocus(GetItem(IDOK).GetSafeHwnd());
		//if(GetItem(IDC_APPLY_FORMAT_BTN).Enable)
		//{
			Control ctrl;
			return OnApply(ctrl);
		//}
		//return TRUE;
	}
	BOOL OnApply(Control ctrl)
	{
		if(!GetItem(IDC_APPLY_FORMAT_BTN).Enable)
			return TRUE;
		GetItem(IDC_APPLY_FORMAT_BTN).Enable = false;
		
		///Jasmine 02/18/08 QA80-11113 NOT_APPLY_UNCHANGED_FORMAT
		TreeNode trGUI = GetTree();
		convert_gui_setting_to_theme(trGUI);//convert_numeric_setting_node(trGUI);	///Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS
		octree_copy_values_by_id(&trGUI, &m_trProp, true, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);
		octree_delete_nodes_by_missing_attribute(&m_trProp, STR_CHANGED_ATTRIB);	///Jasmine 06/06/07 ONLY_APPLY_CHANGE
		///End NOT_APPLY_UNCHANGED_FORMAT
		
		Tree trFmt;
		trFmt = m_dr.GetFormat(FPB_ALL, FOB_ALL & ~(FOB_LINK_STYLE|FOB_RANGE_STYLE|FOB_NAME_STYLE), TRUE, TRUE);
		///Kyle 08/11/2009 QA80-12339 CELL_FORMAT_ADD_FONT_AND_COLOR_CONTROL
		/*
		TreeNode trProp = trFmt.Root.CommonStyle;
		if(!trProp.IsValid())
			return FALSE;
		//make sure trFmt has these nodes
	    trProp.WrapText.nVal = FALSE;
	    trProp.AllowEnter.nVal = TRUE;
	    trProp.Float.nVal = FALSE;
	    //trProp.Flood.nVal = FALSE;	///Jasmine 09/21/07 QA70-10401 SELDOM_USE_SO_REMOVE_FLOOD
	    trProp.Merge.nVal = GMC_NONE;
//------ CPY 2/26/08 QA70-11111 IGNORE_BLANK_MISSING_RANGE_STYLE	
//	    trProp.BlankMissing.nVal = FALSE;
//------
	    trProp.Format.strVal = "";	///Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS, default should be empty
	    ///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
#ifdef ADD_STYLE_CONTROL
	    trProp.Control.strVal = "Origin Text Edit";		///Folger 05/09/07 ADD_STYLE_CONTROL
#endif
		//---------Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT
		trProp.Ellipsis.nVal = 0;
		//---------end ADD_ELLIPSIS_INTO_TEXT_FORMAT
		int iRet = m_dr.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag");
		
		///Jasmine 02/18/08 QA80-11113 NOT_APPLY_UNCHANGED_FORMAT
		//apply format to dr
		//bool bRet = octree_copy_values_by_id(&trGUI, &trProp, true, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
		bool bRet = octree_copy_values_by_id(&m_trProp, &trProp, true, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
		foreach(TreeNode cNode in trProp.Children)
	    {
	    	TreeNode trNode = tree_get_node_by_tagname(m_trProp, cNode.tagName, true);	
    		if(!trNode)
    			cNode.Remove();
	    }
	    ///End NOT_APPLY_UNCHANGED_FORMAT
	    */
	    int iRet = _gui_to_format_tree(m_dr, trFmt, m_trProp, trGUI);
	    ///End CELL_FORMAT_ADD_FONT_AND_COLOR_CONTROL
	    
		///Folger 05/09/07 ADD_STYLE_CONTROL
//#ifdef ADD_STYLE_CONTROL
		//if (trGUI.Control.nVal == 1)
		    	//trProp.Control.strVal = "Edit Control";
		    //else
		    	//trProp.Control.strVal = "Origin Text";
//#endif
		///End ADD_STYLE_CONTROL
		///End ADD_RICH_TEXT_CHEKBOX
		
		BEFORE_UNDO_BLOCK	///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
		
		int nRange = m_dr.GetNumData();
		for(int ii = 0; ii < nRange; ii++)
		{
			int r1, c1, r2, c2;
			Worksheet wks;
			m_dr.GetRange(ii, r1, c1, r2, c2, wks);
			if(!wks)
				continue;
			/// RVD 1/8/2008 QA70-10692 v8.0781 MERGE_ENTIRE_COLUMN
			//if(!r1 && -1 == r2)	///Jasmine 03/02/07 if entire columns selected, omit label region
			//	r2 = wks.GetNumRows() - 1; 
			/// end MERGE_ENTIRE_COLUMN
			DataRange dr;
			dr.Create();
			dr.Add("X", wks, r1, c1, r2, c2);
			iRet = dr.ApplyFormat(trFmt, TRUE, TRUE, TRUE);///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
		}
		AFTER_UNDO_BLOCK	///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
		
		///Jasmine 02/18/08 QA80-11113 NOT_APPLY_UNCHANGED_FORMAT
		GetDataRangeSetting(trGUI);
		m_trProp = trGUI.Clone();
		///End NOT_APPLY_UNCHANGED_FORMAT
		return TRUE;
	}
	void OnAfterValueChange(int nRow, DWORD lParam)
	{	
		bool bEnable = CheckError();	///Jasmine 09/06/07 SHOW_ERROR_MESSAGE
		GetItem(IDC_APPLY_FORMAT_BTN).Enable = bEnable;//true;
		
		//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
		TreeNode trGUI = GetTree();
		TreeNode trChanged = m_DynaCntrl.GetTreeNode(nRow);
		set_control_and_format_changed(trGUI, trChanged);
		//------
		
		UpdateDynaControl(false, GETNEVENT_ON_INIT, false);
	}
public:
	TreeNode ConstructTree()
	{
		TreeNode trGUI = InitTree();
		///Jasmine 02/26/07 UTILITY_FUNC_FOR_TEXT_FORMAT
		/*
		GETN_USE(trGUI)
		GETN_CHECK(WrapText, "Wrap Text", FALSE)						GETN_ID(OTID_STYLE_WRAP)
		GETN_CHECK(Float, "Float", 1)							GETN_ID(OTID_STYLE_FLOAT)
		GETN_CHECK(Flood, "Flood", 1)							GETN_ID(OTID_STYLE_FLOOD)
		GETN_STR(Format, "Format", ".3")							GETN_ID(OTID_STYLE_FORMAT)
		GETN_LIST(Merge, "Merge", GMC_NONE, "None|Horizontal|Vertical|Both") GETN_ID(OTID_STYLE_MERGE)
		GETN_CHECK(BlankMissing, "Show Missing as Blank", TRUE)				GETN_ID(OTID_STYLE_SHOWMISSINGBLANK)
		GETN_CHECK(AllowEnter, "Allow Enter", 1)					GETN_ID(OTID_STYLE_ALLOW_ENTER)
		*/
		construct_text_format_tree(trGUI, false);//------ CPY 2/26/08 QA70-11111 IGNORE_BLANK_MISSING_RANGE_STYLE added false
		///End UTILITY_FUNC_FOR_TEXT_FORMAT
		return trGUI;
	}
	string GetCurrentDataRange()
	{
		string strRange;
		m_dr.CreateFromActive(0);
		if(m_dr)
			m_dr.GetRangeString(strRange);
			//return false;
		/*
		for(int ii = 0; ii < m_dr.GetNumData(); ii++)
		{
			DataRange drSub;
			//m_dr.GetSubRange(drSub, DRR_COLUMN_INDEX, ii);
			int r1, c1, r2, c2;
			Worksheet wks;
			if(m_dr.GetRange(ii, r1, c1, r2, c2, wks) && wks.IsValid())
			{
				drSub.Create();
				drSub.Add("X", wks, r1, c1, r2, c2);
				strRange += drSub.GetDescription() + ",";
			}
		}
		strRange.TrimRight(',');
		bool bValid = !strRange.IsEmpty();
		GetItem(IDC_CELL_RANGE).Text = bValid? strRange : "Please select some cell";
		*/
		return strRange;//bValid;
	}
	bool GetDataRangeSetting(TreeNode& trCellFormat)//get current setting
	{	///Jasmine 02/26/07 UTILITY_FUNC_FOR_TEXT_FORMAT
		_enable_tree(trCellFormat);
		return get_text_format(m_dr, trCellFormat, "CommonStyle");
		/*
		Tree trFmt;
		trFmt = m_dr.GetFormat(FPB_ALL, FOB_ALL & ~(FOB_LINK_STYLE|FOB_RANGE_STYLE|FOB_NAME_STYLE), TRUE, TRUE);
	    TreeNode trProp = trFmt.Root.CommonStyle;
	    if(!trProp.IsValid())
	    	return false;
	    if(trProp.Borders)
	    	trProp.Borders.Remove();
	    //make sure trFmt has these nodes, and set default value
	    if(!trProp.WrapText)
	    	trProp.WrapText.nVal = FALSE;
	    if(!trProp.AllowEnter)
	    	trProp.AllowEnter.nVal = TRUE;
	    if(!trProp.Float)
	    	trProp.Float.nVal = FALSE;
	    if(!trProp.Flood)
	    	trProp.Flood.nVal = FALSE;
	    if(!trProp.Merge)
	    	trProp.Merge.nVal = GMC_NONE;
	    if(!trProp.BlankMissing)
	    	trProp.BlankMissing.nVal = FALSE;
	    if(!trProp.Format)
	    	trProp.Format.strVal = ".5";
	    int iRet = m_dr.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag");
	    octree_copy_values_by_id(&trProp, &trCellFormat, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
	    _enable_tree(trCellFormat);
		return true;
		*/
		///End UTILITY_FUNC_FOR_TEXT_FORMAT
	}
private:
	void update()
	{
		TreeNode trGUI = GetTree();
		string strRange = GetCurrentDataRange();
		if(strRange.IsEmpty())
		{
			strRange = _L("Please select some cell");
			_enable_tree(trGUI, false);
		}
		else if(strRange.CompareNoCase(GetItem(IDC_CELL_RANGE).Text))
		{
			GetDataRangeSetting(trGUI);
			m_trProp = trGUI.Clone();	///Jasmine 02/18/08 QA80-11113 NOT_APPLY_UNCHANGED_FORMAT
		///Jasmine 08/28/08 QA80-12112 UPDATE_CONTROL_EVEN_IF_RANGE_IS_INVALID
			//CheckError();
			//UpdateDynaControl(false, GETNEVENT_ON_INIT, false);
		}
		CheckError();
		UpdateDynaControl(false, GETNEVENT_ON_INIT, false);
		///End UPDATE_CONTROL_EVEN_IF_RANGE_IS_INVALID
		GetItem(IDC_CELL_RANGE).Text = strRange;
	}
	//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
	void resizeDialog(int cx = 0, int cy = 0)
	{
		int nEdge = GetControlGap();
				
		RECT rrWnd;
		GetClientRect(&rrWnd);
		
		if (cx == 0)
			cx = rrWnd.right - rrWnd.left;
		if (cy == 0)
			cy = rrWnd.bottom - rrWnd.top;
		
		int nErrMessageHeight = GetDlgStatusMsgBoxHeight(cx - 2 * nEdge);
		int	nErrMessage = nErrMessageHeight > 0 ? nErrMessageHeight + nEdge : 0;		
			
		uint nButtonIDs[] = {IDCANCEL, IDOK, IDC_APPLY_FORMAT_BTN, 0};
		RECT rr;
		GetClientRect(GetItem(IDOK), rr);
		int ny=cy-RECT_HEIGHT(rr)-nErrMessage;
				
		GetClientRect(GetItem(IDC_CELL_RANGE), rr);
		rr.right = cx - nEdge;
		MoveControl(GetItem(IDC_CELL_RANGE), rr); 
		
		GetClientRect(m_tab, rr);
		rr.right = cx-nEdge;
		rr.bottom = ny-nEdge;
		MoveControl(m_tab, rr);
		m_tab.GetWindowRect(&rr);
		ScreenToClient(&rr);
		m_tab.AdjustRect(FALSE, &rr);
		Control ccGrid = GetItem(IDC_CELL_FORMAT_GRID);
		ccGrid.MoveWindow(&rr);
		
		MoveControlsHelper	_temp(this);		///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
		ArrangeControlsRightLeft(nButtonIDs, cx, ny + nErrMessage);//only affect buttons
		
		if (nErrMessage)
		{
			RECT rrStatusBar;
			GetClientRect(m_btnErrMessage, rrStatusBar);
			rrStatusBar.top = ny;
			rrStatusBar.bottom = rrStatusBar.top + nErrMessageHeight;
			rrStatusBar.left = nEdge;
			rrStatusBar.right = cx - nEdge;
			MoveControl(m_btnErrMessage, rrStatusBar);
		}
		
	}
	///Jasmine 09/06/07 SHOW_ERROR_MESSAGE
	void checkShowStatusBar()
	{
		bool bShow = m_btnErrMessage.Visible = !m_strErrMsg.IsEmpty();//m_nErr != CER_NO_ERROR;
		if (bShow)
		{
			//string str;
			//ocu_load_err_msg_str(m_nErr, &str);
			m_btnErrMessage.Text = m_strErrMsg;//str;
		}
		else
			m_btnErrMessage.Text = "";
		resizeDialog();
	}
	
	bool setCheckErrorStatus(LPCSTR lpcszErrMsg = NULL)
	{
		//m_nErr = nErr;
		m_strErrMsg = lpcszErrMsg;
		checkShowStatusBar();
		return true;
	}
	//------ End SHOW_ERROR_STATUS_BAR
public:	
	bool CheckError()
	{
		bool bEnable = true;
		string strLoad, strErrMsg;	
		TreeNode trGUI = GetTree();	
		
		if(strErrMsg.IsEmpty())
		{
			TreeNode trOriginTextControl = tree_get_node_by_tagname(trGUI, "OriginTextControl", true);
			if(true == trOriginTextControl.nVal)
			{
				ocu_load_err_msg_str(IGNORE_SETTING_ATTENTION, &strLoad);
				//----- CPY 2/26/08 QA80-11159 ORIGIN_TEXT_IN_WKS_CELL_NOT_ALLOW_MULTILINE
				//strErrMsg.Format(strLoad, _L("Wrap Text, Float, Ellipsis and Allow Enter"), _L("Rich Text"));
				strErrMsg.Format(strLoad, _L("Wrap Text, Float and Ellipsis"), _L("Rich Text"));
				//-----
			}
		}
		///Jsamine 09/24/07 QA70-10353 CP_FIX_ALLOWENTER_BUG
		/*
		if(strErrMsg.IsEmpty())
		{
			TreeNode trAllowEnter = tree_get_node_by_tagname(trGUI, "AllowEnter", true);
			if(true == trAllowEnter.nVal)
			{
				ocu_load_err_msg_str(IGNORE_SETTING_ATTENTION, &strLoad);
				strErrMsg.Format(strLoad, _L("Ellipsis"), _L("Allow Enter"));
			}
		}
		*/
		///End CP_FIX_ALLOWENTER_BUG
		setCheckErrorStatus(strErrMsg);
		return bEnable;
	}
	///End SHOW_ERROR_MESSAGE
private:
	TreeNode	m_trProp;	///Jasmine 02/18/08 QA80-11113 NOT_APPLY_UNCHANGED_FORMAT
	
	TabControl	m_tab;
	DataRange 	m_dr;
	bool		m_bDeleteOnDestroy;
	//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
	//int			m_nErr;	///Jasmine 09/06/07 SHOW_ERROR_MESSAGE
	string 		m_strErrMsg;
	//Button		m_btnErrMessage;	///Jasmine 05/22/08 m_btnErrMessage_IS_IN_BASIC_CLASS_DYNA_DLG
	//------ End SHOW_ERROR_STATUS_BAR
};

int CellFormat(int nMsg, DWORD dwCntrl = 0, LPVOID lpData = NULL)
{
	bool bClose = OMSG_CLOSE==nMsg? true:false;
	bool bUpdate = OMSG_UPDATE==nMsg? true:false;
	if(bClose)
	{
		if(s_pCellFormatDlg)
		{
			Window winDlg = s_pCellFormatDlg->GetWindow();
			if(winDlg)
				winDlg.SendMessage(WM_CLOSE);
			delete s_pCellFormatDlg;
			s_pCellFormatDlg = NULL;
		}
		return 0;
	}
	// open or update
	if(!s_pCellFormatDlg)
	{
		if(bUpdate)
			return 1;// not possible to update, since dialog not opened
		s_pCellFormatDlg = new CellFormatDlg;
		s_pCellFormatDlg->Create(GetWindow());
	}
	if(bUpdate)
		;//s_pCellFormatDlg->Update();//"from global message");	
	return 0;
}
/*
void FormatCells()
{
	int nRet = CellFormat(0, 0, NULL);
	return;
}
*/
